<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Set number of allowed characters to be able to shorten an rss item description -->
<xsl:param name="allowable-length" select="200"/>
  
<xsl:template match="rss/channel">
    <div class="rss">
        <!-- start the items -->
        <xsl:call-template name="item" />
    </div>
</xsl:template>
  
<xsl:template name="item">
    <xsl:for-each select="//*[local-name()='item'][position() &lt; 3]">
      <table border="0" cellpadding="0" cellspacing="0" summary="">
        <tr>
          <td class="feed-item">
            <table border="0" cellpadding="0" cellspacing="0" summary="">
              <tr>
                <td class="feed-title">
                  <a href="{link}" title="{title}">
                    <xsl:value-of select="title" disable-output-escaping="yes" />
                  </a>
                </td>
              </tr>
              <tr>
                <td class="feed-desc">
                  <xsl:value-of select="substring(description, 1, $allowable-length)" disable-output-escaping="yes"/>
                  <xsl:if test="string-length(description) &gt; $allowable-length">
                    <xsl:text>...</xsl:text><a href="{link}" title="{title}">Learn more</a>
                  </xsl:if>  
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
